using System;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Provides User Interface to create a new local supplier
	/// </summary>
	///<remarks>
	///<newpara> Package: VBECS - VistA Blood Establishment Computer System</newpara>
	///<newpara> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</newpara>
	///<newpara> Medical Device #: $MEDDEVICENO</newpara>
	///<newpara> Date Created: 4/30/2002</newpara>
	///<newpara> Site Name: Hines OIFO </newpara>
	///<newpara> Developers: Cameron Taylor, Keith Franklin</newpara>
	///<newpara> Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</newpara>
	///</remarks>
	///

	public class FrmCollectionFacilityMaintain : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region Variables
		
		/// <summary>
		/// Holds the local supplier object that the user is working with
		/// </summary>
		private BOL.LocalSupplier _currentLocalSuplier;

		/// <summary>
		/// If we're coming from UC1 we only want to let the user perform one update
		/// </summary>
		private bool _processOne = false;

		/// <summary>
		/// Because there is code in the textChanged, and Leave events of our controls, we
		/// don't want these events to fire when the form is being loaded.  So we use this, which
		/// indicates if the data is being populated via code (true) or user entry(false)
		/// </summary>
		private bool _isLoading = false;

		/// <summary>
		/// Local storage for the FDARegistrationNumber property 
		/// </summary>
		private string _fdaRegistrationNumber;
		private bool _ISBT = false;
		private bool _isBrandNewFacility = false;		//Is the user entering a brand new facility?

		#endregion

		#region FormControls
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpProduct;
		private gov.va.med.vbecs.GUI.controls.BarcodeTextbox txtFDAReg;
		private System.Windows.Forms.Label lblFacilityName;
		private System.Windows.Forms.Label lblFDAReg;
		private System.Windows.Forms.TextBox txtFacilityName;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpAddress;
		private System.Windows.Forms.GroupBox grpAdditionalInfo;
		private System.Windows.Forms.CheckBox cbAlpha;
		private System.Windows.Forms.TextBox edtPrefix;
		private System.Windows.Forms.Label lblPrefix;
		private System.Windows.Forms.Label lblAddress;
		private System.Windows.Forms.Label lblState;
		private System.Windows.Forms.Label lblZip;
		private System.Windows.Forms.TextBox txtCity;
		private System.Windows.Forms.Label lblCity;
		private System.Windows.Forms.TextBox txtAddress3;
		private System.Windows.Forms.TextBox txtAddress2;
		private System.Windows.Forms.TextBox txtAddress1;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbState;
		private gov.va.med.vbecs.GUI.controls.MaskedTextBox mtxtPhone;
		private gov.va.med.vbecs.GUI.controls.MaskedTextBox mtxtFax;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpFacilityIndicator;
		private System.Windows.Forms.GroupBox grpActive;
		private System.Windows.Forms.CheckBox cbActive;
		private System.Windows.Forms.Label lblPhone;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.Label lblAlpha;
		private System.Windows.Forms.Label lblCollectionFacility;
		private System.Windows.Forms.Label lblTestingFacility;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.CheckBox cbTestingFacility;
		private System.Windows.Forms.CheckBox cbCollectionFacility;
		private System.Windows.Forms.TextBox txtIccbba;
		private System.Windows.Forms.Label lblIccbba;
		private gov.va.med.vbecs.GUI.controls.MaskedTextBox mtxtZip;
		private System.Windows.Forms.Label lblAddressLine2;
		private System.Windows.Forms.Label lblAddressLine3;
		private System.Windows.Forms.Button btnSearch;
		#endregion

		#region Constructors
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/8/2002</CreationDate>
		///<summary>
		///Controls initialization of Form. Creates a new local supplier and binds to controls
		///</summary>
		public FrmCollectionFacilityMaintain()
		{
			if (HasAuthorityToActivateEdit())
			{
				InitializeComponent();
				SetComponentProperties();

				this.SetControlData(true);
				this.SetControlState(false);
				this.Height = 195;
			}
			else
			{
				this.Close();
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/30/2002</CreationDate>
		/// <summary>
		/// Controls initialization of Form with the FDARegistrationNumber prefilled. Creates a new local supplier and binds to controls
		/// Coming here from UC_8
		/// </summary>	
		///<param name="fdaRegistrationNumber">string</param>
		public FrmCollectionFacilityMaintain(string fdaRegistrationNumber)
		{
			if (this.HasAuthorityToActivateEdit())
			{
				this.InitializeComponent();
				this.SetComponentProperties();
			
				this._processOne = true;

				if (fdaRegistrationNumber.Trim().Length == 7 || fdaRegistrationNumber.Trim().Length == 10)
				{
					if(!this.SetCurrentCollectionFacility(fdaRegistrationNumber))
					{
						this.DialogResult = DialogResult.Abort;
						this.Close();
					}
					
					string tooltip = Common.Utility.SumBrokenRulesMessages( 
						_currentLocalSuplier.GetBrokenRulesMessage( this.Name ),
						_currentLocalSuplier.Address.GetBrokenRulesMessage( this.Name ),
						this.errError.GetError(this.txtIccbba));

					//Enable the button since everything is set for us by default
					if (tooltip.Length == 0)
						this.btnOK.EnabledButton = true;
				}
				else
				{
					this._isLoading = true;
					this.btnClear_Click(this, System.EventArgs.Empty);
					this.txtFDAReg.Text = fdaRegistrationNumber;
					this.txtFDAReg.Select(this.Text.Trim().Length,0);
					this._isLoading = false;
				}
			}
			else
			{
				this.DialogResult = DialogResult.Abort;
				this.Close();
			}
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="ICCBARegNum"></param>
		/// <param name="tTest"></param>
		public FrmCollectionFacilityMaintain(string ICCBARegNum, bool tTest)
		{
			if (this.HasAuthorityToActivateEdit())
			{
				this.InitializeComponent();
				this.SetComponentProperties();
				this._ISBT = true;
				this._processOne = true;

				if (ICCBARegNum.Trim().Length == 5)
				{
					if(!this.SetCurrentCollectionFacility(ICCBARegNum, true))
					{
						this.Close();
					}
				}
				else
				{
					this._isLoading = true;
					this.btnClear_Click(this, System.EventArgs.Empty);
					this.txtIccbba.Text = ICCBARegNum;
					this.txtIccbba.Select(this.Text.Trim().Length,0);
					this._isLoading = false;
				}
			}
			else
			{
				this.Close();
			}
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmCollectionFacilityMaintain));
            this.btnCancel = new System.Windows.Forms.Button();
            this.grpProduct = new System.Windows.Forms.GroupBox();
            this.lblIccbba = new System.Windows.Forms.Label();
            this.txtIccbba = new System.Windows.Forms.TextBox();
            this.btnClear = new System.Windows.Forms.Button();
            this.txtFacilityName = new System.Windows.Forms.TextBox();
            this.pictureBox2 = new System.Windows.Forms.PictureBox();
            this.btnSearch = new System.Windows.Forms.Button();
            this.txtFDAReg = new gov.va.med.vbecs.GUI.controls.BarcodeTextbox(this.components);
            this.lblFacilityName = new System.Windows.Forms.Label();
            this.lblFDAReg = new System.Windows.Forms.Label();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpAddress = new System.Windows.Forms.GroupBox();
            this.lblAddressLine3 = new System.Windows.Forms.Label();
            this.lblAddressLine2 = new System.Windows.Forms.Label();
            this.mtxtZip = new gov.va.med.vbecs.GUI.controls.MaskedTextBox();
            this.lblPhone = new System.Windows.Forms.Label();
            this.mtxtFax = new gov.va.med.vbecs.GUI.controls.MaskedTextBox();
            this.mtxtPhone = new gov.va.med.vbecs.GUI.controls.MaskedTextBox();
            this.cmbState = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.label2 = new System.Windows.Forms.Label();
            this.lblAddress = new System.Windows.Forms.Label();
            this.lblState = new System.Windows.Forms.Label();
            this.lblZip = new System.Windows.Forms.Label();
            this.txtCity = new System.Windows.Forms.TextBox();
            this.lblCity = new System.Windows.Forms.Label();
            this.txtAddress3 = new System.Windows.Forms.TextBox();
            this.txtAddress2 = new System.Windows.Forms.TextBox();
            this.txtAddress1 = new System.Windows.Forms.TextBox();
            this.grpAdditionalInfo = new System.Windows.Forms.GroupBox();
            this.lblAlpha = new System.Windows.Forms.Label();
            this.cbAlpha = new System.Windows.Forms.CheckBox();
            this.edtPrefix = new System.Windows.Forms.TextBox();
            this.lblPrefix = new System.Windows.Forms.Label();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
            this.grpFacilityIndicator = new System.Windows.Forms.GroupBox();
            this.lblTestingFacility = new System.Windows.Forms.Label();
            this.lblCollectionFacility = new System.Windows.Forms.Label();
            this.cbTestingFacility = new System.Windows.Forms.CheckBox();
            this.cbCollectionFacility = new System.Windows.Forms.CheckBox();
            this.grpActive = new System.Windows.Forms.GroupBox();
            this.label1 = new System.Windows.Forms.Label();
            this.cbActive = new System.Windows.Forms.CheckBox();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpProduct.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpAddress.SuspendLayout();
            this.grpAdditionalInfo.SuspendLayout();
            this.grpFacilityIndicator.SuspendLayout();
            this.grpActive.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(444, 30);
            this.vbecsLogo1.TabIndex = 7;
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 491);
            this.lblRequiredField.TabIndex = 9;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.CausesValidation = false;
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(364, 466);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 19;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // grpProduct
            // 
            this.grpProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpProduct.Controls.Add(this.lblIccbba);
            this.grpProduct.Controls.Add(this.txtIccbba);
            this.grpProduct.Controls.Add(this.btnClear);
            this.grpProduct.Controls.Add(this.txtFacilityName);
            this.grpProduct.Controls.Add(this.pictureBox2);
            this.grpProduct.Controls.Add(this.btnSearch);
            this.grpProduct.Controls.Add(this.txtFDAReg);
            this.grpProduct.Controls.Add(this.lblFacilityName);
            this.grpProduct.Controls.Add(this.lblFDAReg);
            this.grpProduct.Location = new System.Drawing.Point(60, 32);
            this.grpProduct.Name = "grpProduct";
            this.grpProduct.Size = new System.Drawing.Size(380, 88);
            this.grpProduct.TabIndex = 0;
            this.grpProduct.TabStop = false;
            // 
            // lblIccbba
            // 
            this.lblIccbba.Location = new System.Drawing.Point(28, 60);
            this.lblIccbba.Name = "lblIccbba";
            this.lblIccbba.Size = new System.Drawing.Size(96, 20);
            this.lblIccbba.TabIndex = 5;
            this.lblIccbba.Text = "ICCBBA Reg. No.";
            this.lblIccbba.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtIccbba
            // 
            this.txtIccbba.AccessibleDescription = "I C C B B A Registration Number";
            this.txtIccbba.AccessibleName = "I C C B B A Registration Number";
            this.txtIccbba.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtIccbba.Location = new System.Drawing.Point(124, 60);
            this.txtIccbba.MaxLength = 5;
            this.txtIccbba.Name = "txtIccbba";
            this.txtIccbba.Size = new System.Drawing.Size(60, 20);
            this.txtIccbba.TabIndex = 4;
            this.txtIccbba.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtIccbba_KeyUp);
            // 
            // btnClear
            // 
            this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClear.CausesValidation = false;
            this.btnClear.Location = new System.Drawing.Point(288, 10);
            this.btnClear.Name = "btnClear";
            this.btnClear.Size = new System.Drawing.Size(75, 23);
            this.btnClear.TabIndex = 20;
            this.btnClear.Text = "C&lear";
            this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
            // 
            // txtFacilityName
            // 
            this.txtFacilityName.AccessibleDescription = "Facility Name";
            this.txtFacilityName.AccessibleName = "Facility Name";
            this.txtFacilityName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtFacilityName.Location = new System.Drawing.Point(124, 36);
            this.txtFacilityName.MaxLength = 120;
            this.txtFacilityName.Name = "txtFacilityName";
            this.txtFacilityName.Size = new System.Drawing.Size(240, 20);
            this.txtFacilityName.TabIndex = 3;
            this.txtFacilityName.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtFacilityName_KeyUp);
            // 
            // pictureBox2
            // 
            this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
            this.pictureBox2.Location = new System.Drawing.Point(8, 16);
            this.pictureBox2.Name = "pictureBox2";
            this.pictureBox2.Size = new System.Drawing.Size(20, 20);
            this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox2.TabIndex = 19;
            this.pictureBox2.TabStop = false;
            // 
            // btnSearch
            // 
            this.btnSearch.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSearch.Location = new System.Drawing.Point(208, 12);
            this.btnSearch.Name = "btnSearch";
            this.btnSearch.Size = new System.Drawing.Size(24, 20);
            this.btnSearch.TabIndex = 2;
            this.btnSearch.Text = "find";
            this.btnSearch.Click += new System.EventHandler(this.btnSearch_Click);
            // 
            // txtFDAReg
            // 
            this.txtFDAReg.AccessibleDescription = "F D A Registration Number";
            this.txtFDAReg.AccessibleName = "F D A Registration Number";
            this.txtFDAReg.Barcode = false;
            this.txtFDAReg.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtFDAReg.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtFDAReg.Location = new System.Drawing.Point(124, 12);
            this.txtFDAReg.MaxLength = 12;
            this.txtFDAReg.Name = "txtFDAReg";
            this.txtFDAReg.Size = new System.Drawing.Size(84, 20);
            this.txtFDAReg.TabIndex = 1;
            this.txtFDAReg.TextChanged += new System.EventHandler(this.txtFDAReg_TextChanged);
            this.txtFDAReg.Leave += new System.EventHandler(this.txtFDAReg_Leave);
            // 
            // lblFacilityName
            // 
            this.lblFacilityName.Location = new System.Drawing.Point(28, 36);
            this.lblFacilityName.Name = "lblFacilityName";
            this.lblFacilityName.Size = new System.Drawing.Size(104, 20);
            this.lblFacilityName.TabIndex = 3;
            this.lblFacilityName.Text = "Facility Name*";
            this.lblFacilityName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblFDAReg
            // 
            this.lblFDAReg.Location = new System.Drawing.Point(28, 12);
            this.lblFDAReg.Name = "lblFDAReg";
            this.lblFDAReg.Size = new System.Drawing.Size(108, 20);
            this.lblFDAReg.TabIndex = 0;
            this.lblFDAReg.Text = "FDA Reg. No.*";
            this.lblFDAReg.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 428);
            this.grpImage.TabIndex = 8;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 20;
            this.pictureBox1.TabStop = false;
            // 
            // grpAddress
            // 
            this.grpAddress.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAddress.Controls.Add(this.lblAddressLine3);
            this.grpAddress.Controls.Add(this.lblAddressLine2);
            this.grpAddress.Controls.Add(this.mtxtZip);
            this.grpAddress.Controls.Add(this.lblPhone);
            this.grpAddress.Controls.Add(this.mtxtFax);
            this.grpAddress.Controls.Add(this.mtxtPhone);
            this.grpAddress.Controls.Add(this.cmbState);
            this.grpAddress.Controls.Add(this.label2);
            this.grpAddress.Controls.Add(this.lblAddress);
            this.grpAddress.Controls.Add(this.lblState);
            this.grpAddress.Controls.Add(this.lblZip);
            this.grpAddress.Controls.Add(this.txtCity);
            this.grpAddress.Controls.Add(this.lblCity);
            this.grpAddress.Controls.Add(this.txtAddress3);
            this.grpAddress.Controls.Add(this.txtAddress2);
            this.grpAddress.Controls.Add(this.txtAddress1);
            this.grpAddress.Location = new System.Drawing.Point(60, 124);
            this.grpAddress.Name = "grpAddress";
            this.grpAddress.Size = new System.Drawing.Size(380, 164);
            this.grpAddress.TabIndex = 1;
            this.grpAddress.TabStop = false;
            // 
            // lblAddressLine3
            // 
            this.lblAddressLine3.Location = new System.Drawing.Point(28, 64);
            this.lblAddressLine3.Name = "lblAddressLine3";
            this.lblAddressLine3.Size = new System.Drawing.Size(88, 16);
            this.lblAddressLine3.TabIndex = 15;
            this.lblAddressLine3.Text = "Address Line 3";
            this.lblAddressLine3.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblAddressLine2
            // 
            this.lblAddressLine2.Location = new System.Drawing.Point(28, 40);
            this.lblAddressLine2.Name = "lblAddressLine2";
            this.lblAddressLine2.Size = new System.Drawing.Size(88, 16);
            this.lblAddressLine2.TabIndex = 14;
            this.lblAddressLine2.Text = "Address Line 2";
            this.lblAddressLine2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // mtxtZip
            // 
            this.mtxtZip.AccessibleDescription = "Zip Code";
            this.mtxtZip.AccessibleName = "Zip Code";
            this.mtxtZip.ErrorMsg = null;
            this.mtxtZip.Location = new System.Drawing.Point(116, 134);
            this.mtxtZip.Mask = "#####-####";
            this.mtxtZip.MaskType = gov.va.med.vbecs.GUI.controls.MaskTypeEnum.Zip;
            this.mtxtZip.Name = "mtxtZip";
            this.mtxtZip.Size = new System.Drawing.Size(80, 24);
            this.mtxtZip.TabIndex = 11;
            this.mtxtZip.MaskedTextValidated += new System.EventHandler(this.mtxtZip_MaskedTextValidated);
            this.mtxtZip.MaskedTextInvalidated += new System.EventHandler(this.mtxtZip_MaskedTextInvalidated);
            // 
            // lblPhone
            // 
            this.lblPhone.Image = ((System.Drawing.Image)(resources.GetObject("lblPhone.Image")));
            this.lblPhone.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.lblPhone.Location = new System.Drawing.Point(216, 112);
            this.lblPhone.Name = "lblPhone";
            this.lblPhone.Size = new System.Drawing.Size(56, 16);
            this.lblPhone.TabIndex = 10;
            this.lblPhone.Text = "Phone";
            this.lblPhone.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // mtxtFax
            // 
            this.mtxtFax.AccessibleDescription = "Fax";
            this.mtxtFax.AccessibleName = "Fax";
            this.mtxtFax.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.mtxtFax.ErrorMsg = "The fax number you have entered is invalid.";
            this.mtxtFax.Location = new System.Drawing.Point(268, 136);
            this.mtxtFax.Mask = "(###) ###-####";
            this.mtxtFax.MaskType = gov.va.med.vbecs.GUI.controls.MaskTypeEnum.Phone;
            this.mtxtFax.Name = "mtxtFax";
            this.mtxtFax.Size = new System.Drawing.Size(104, 24);
            this.mtxtFax.TabIndex = 12;
            this.mtxtFax.Leave += new System.EventHandler(this.mtxtFax_Leave);
            // 
            // mtxtPhone
            // 
            this.mtxtPhone.AccessibleDescription = "Phone";
            this.mtxtPhone.AccessibleName = "Phone";
            this.mtxtPhone.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.mtxtPhone.ErrorMsg = "The phone number you have entered is invalid.";
            this.mtxtPhone.Location = new System.Drawing.Point(268, 112);
            this.mtxtPhone.Mask = "(###) ###-####";
            this.mtxtPhone.MaskType = gov.va.med.vbecs.GUI.controls.MaskTypeEnum.Phone;
            this.mtxtPhone.Name = "mtxtPhone";
            this.mtxtPhone.Size = new System.Drawing.Size(104, 24);
            this.mtxtPhone.TabIndex = 10;
            this.mtxtPhone.Leave += new System.EventHandler(this.mtxtPhone_Leave);
            // 
            // cmbState
            // 
            this.cmbState.AccessibleDescription = "State";
            this.cmbState.AccessibleName = "State";
            this.cmbState.Interval = 100;
            this.cmbState.Location = new System.Drawing.Point(124, 108);
            this.cmbState.MaxLength = 2;
            this.cmbState.Name = "cmbState";
            this.cmbState.Size = new System.Drawing.Size(64, 22);
            this.cmbState.TabIndex = 9;
            this.cmbState.SelectedIndexChanged += new System.EventHandler(this.cmbState_SelectedIndexChanged);
            // 
            // label2
            // 
            this.label2.Image = ((System.Drawing.Image)(resources.GetObject("label2.Image")));
            this.label2.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.label2.Location = new System.Drawing.Point(216, 136);
            this.label2.Name = "label2";
            this.label2.Size = new System.Drawing.Size(44, 16);
            this.label2.TabIndex = 12;
            this.label2.Text = "Fax";
            this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // lblAddress
            // 
            this.lblAddress.Location = new System.Drawing.Point(28, 16);
            this.lblAddress.Name = "lblAddress";
            this.lblAddress.Size = new System.Drawing.Size(88, 16);
            this.lblAddress.TabIndex = 0;
            this.lblAddress.Text = "Facility Address";
            this.lblAddress.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblState
            // 
            this.lblState.Location = new System.Drawing.Point(28, 112);
            this.lblState.Name = "lblState";
            this.lblState.Size = new System.Drawing.Size(88, 16);
            this.lblState.TabIndex = 6;
            this.lblState.Text = "State*";
            this.lblState.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblZip
            // 
            this.lblZip.Location = new System.Drawing.Point(28, 136);
            this.lblZip.Name = "lblZip";
            this.lblZip.Size = new System.Drawing.Size(88, 16);
            this.lblZip.TabIndex = 8;
            this.lblZip.Text = "Zip Code";
            this.lblZip.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCity
            // 
            this.txtCity.AccessibleDescription = "City";
            this.txtCity.AccessibleName = "City";
            this.txtCity.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCity.Location = new System.Drawing.Point(124, 84);
            this.txtCity.MaxLength = 55;
            this.txtCity.Name = "txtCity";
            this.txtCity.Size = new System.Drawing.Size(240, 20);
            this.txtCity.TabIndex = 8;
            this.txtCity.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtCity_KeyUp);
            // 
            // lblCity
            // 
            this.lblCity.Location = new System.Drawing.Point(28, 88);
            this.lblCity.Name = "lblCity";
            this.lblCity.Size = new System.Drawing.Size(88, 16);
            this.lblCity.TabIndex = 4;
            this.lblCity.Text = "City*";
            this.lblCity.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtAddress3
            // 
            this.txtAddress3.AccessibleDescription = "Address Line 3";
            this.txtAddress3.AccessibleName = "Address Line 3";
            this.txtAddress3.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtAddress3.Location = new System.Drawing.Point(124, 60);
            this.txtAddress3.MaxLength = 255;
            this.txtAddress3.Name = "txtAddress3";
            this.txtAddress3.Size = new System.Drawing.Size(240, 20);
            this.txtAddress3.TabIndex = 7;
            this.txtAddress3.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtAddress3_KeyUp);
            // 
            // txtAddress2
            // 
            this.txtAddress2.AccessibleDescription = "Address Line 2";
            this.txtAddress2.AccessibleName = "Address Line 2";
            this.txtAddress2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtAddress2.Location = new System.Drawing.Point(124, 36);
            this.txtAddress2.MaxLength = 255;
            this.txtAddress2.Name = "txtAddress2";
            this.txtAddress2.Size = new System.Drawing.Size(240, 20);
            this.txtAddress2.TabIndex = 6;
            this.txtAddress2.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtAddress2_KeyUp);
            // 
            // txtAddress1
            // 
            this.txtAddress1.AccessibleDescription = "Facility Address";
            this.txtAddress1.AccessibleName = "Facility Address";
            this.txtAddress1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtAddress1.Location = new System.Drawing.Point(124, 12);
            this.txtAddress1.MaxLength = 255;
            this.txtAddress1.Name = "txtAddress1";
            this.txtAddress1.Size = new System.Drawing.Size(240, 20);
            this.txtAddress1.TabIndex = 5;
            this.txtAddress1.KeyUp += new System.Windows.Forms.KeyEventHandler(this.txtAddress1_KeyUp);
            // 
            // grpAdditionalInfo
            // 
            this.grpAdditionalInfo.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAdditionalInfo.Controls.Add(this.lblAlpha);
            this.grpAdditionalInfo.Controls.Add(this.cbAlpha);
            this.grpAdditionalInfo.Controls.Add(this.edtPrefix);
            this.grpAdditionalInfo.Controls.Add(this.lblPrefix);
            this.grpAdditionalInfo.Location = new System.Drawing.Point(60, 292);
            this.grpAdditionalInfo.Name = "grpAdditionalInfo";
            this.grpAdditionalInfo.Size = new System.Drawing.Size(380, 64);
            this.grpAdditionalInfo.TabIndex = 2;
            this.grpAdditionalInfo.TabStop = false;
            this.grpAdditionalInfo.Text = "Codabar Unit Format";
            // 
            // lblAlpha
            // 
            this.lblAlpha.Location = new System.Drawing.Point(24, 18);
            this.lblAlpha.Name = "lblAlpha";
            this.lblAlpha.Size = new System.Drawing.Size(208, 16);
            this.lblAlpha.TabIndex = 0;
            this.lblAlpha.Text = "&Unit ID contains alpha characters?";
            // 
            // cbAlpha
            // 
            this.cbAlpha.AccessibleDescription = "Unit I D Contains Alpha Characters?";
            this.cbAlpha.AccessibleName = "Unit I D Contains Alpha Characters?";
            this.cbAlpha.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbAlpha.Location = new System.Drawing.Point(256, 16);
            this.cbAlpha.Name = "cbAlpha";
            this.cbAlpha.Size = new System.Drawing.Size(24, 20);
            this.cbAlpha.TabIndex = 13;
            this.cbAlpha.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.cbAlpha.CheckedChanged += new System.EventHandler(this.cbAlpha_CheckedChanged);
            // 
            // edtPrefix
            // 
            this.edtPrefix.AccessibleDescription = "2 digit eye-readable prefix if applicable";
            this.edtPrefix.AccessibleName = "2 digit eye-readable prefix if applicable";
            this.edtPrefix.Location = new System.Drawing.Point(266, 36);
            this.edtPrefix.MaxLength = 2;
            this.edtPrefix.Name = "edtPrefix";
            this.edtPrefix.Size = new System.Drawing.Size(28, 20);
            this.edtPrefix.TabIndex = 14;
            this.edtPrefix.TextChanged += new System.EventHandler(this.edtPrefix_TextChanged);
            // 
            // lblPrefix
            // 
            this.lblPrefix.Location = new System.Drawing.Point(24, 40);
            this.lblPrefix.Name = "lblPrefix";
            this.lblPrefix.Size = new System.Drawing.Size(232, 16);
            this.lblPrefix.TabIndex = 2;
            this.lblPrefix.Text = "2-digit eye-readable prefix (if applicable)";
            this.lblPrefix.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.EnabledButton = false;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(284, 466);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 18;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // grpFacilityIndicator
            // 
            this.grpFacilityIndicator.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpFacilityIndicator.Controls.Add(this.lblTestingFacility);
            this.grpFacilityIndicator.Controls.Add(this.lblCollectionFacility);
            this.grpFacilityIndicator.Controls.Add(this.cbTestingFacility);
            this.grpFacilityIndicator.Controls.Add(this.cbCollectionFacility);
            this.grpFacilityIndicator.Location = new System.Drawing.Point(60, 360);
            this.grpFacilityIndicator.Name = "grpFacilityIndicator";
            this.grpFacilityIndicator.Size = new System.Drawing.Size(380, 60);
            this.grpFacilityIndicator.TabIndex = 3;
            this.grpFacilityIndicator.TabStop = false;
            this.grpFacilityIndicator.Text = "Facility Type*";
            // 
            // lblTestingFacility
            // 
            this.lblTestingFacility.Location = new System.Drawing.Point(24, 38);
            this.lblTestingFacility.Name = "lblTestingFacility";
            this.lblTestingFacility.Size = new System.Drawing.Size(108, 16);
            this.lblTestingFacility.TabIndex = 2;
            this.lblTestingFacility.Text = "&Testing Facility?";
            // 
            // lblCollectionFacility
            // 
            this.lblCollectionFacility.Location = new System.Drawing.Point(24, 18);
            this.lblCollectionFacility.Name = "lblCollectionFacility";
            this.lblCollectionFacility.Size = new System.Drawing.Size(188, 16);
            this.lblCollectionFacility.TabIndex = 0;
            this.lblCollectionFacility.Text = "Collection &Facility?";
            // 
            // cbTestingFacility
            // 
            this.cbTestingFacility.AccessibleDescription = "Testing Facility";
            this.cbTestingFacility.AccessibleName = "Testing Facility";
            this.cbTestingFacility.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbTestingFacility.Location = new System.Drawing.Point(256, 36);
            this.cbTestingFacility.Name = "cbTestingFacility";
            this.cbTestingFacility.Size = new System.Drawing.Size(24, 20);
            this.cbTestingFacility.TabIndex = 16;
            this.cbTestingFacility.CheckedChanged += new System.EventHandler(this.cbTestingFacility_CheckedChanged);
            // 
            // cbCollectionFacility
            // 
            this.cbCollectionFacility.AccessibleDescription = "Collection Facility";
            this.cbCollectionFacility.AccessibleName = "Collection Facility";
            this.cbCollectionFacility.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbCollectionFacility.Location = new System.Drawing.Point(248, 16);
            this.cbCollectionFacility.Name = "cbCollectionFacility";
            this.cbCollectionFacility.Size = new System.Drawing.Size(32, 20);
            this.cbCollectionFacility.TabIndex = 15;
            this.cbCollectionFacility.CheckedChanged += new System.EventHandler(this.cbCollectionFacility_CheckedChanged);
            // 
            // grpActive
            // 
            this.grpActive.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpActive.Controls.Add(this.label1);
            this.grpActive.Controls.Add(this.cbActive);
            this.grpActive.Location = new System.Drawing.Point(60, 424);
            this.grpActive.Name = "grpActive";
            this.grpActive.Size = new System.Drawing.Size(380, 36);
            this.grpActive.TabIndex = 4;
            this.grpActive.TabStop = false;
            // 
            // label1
            // 
            this.label1.Location = new System.Drawing.Point(24, 14);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(160, 14);
            this.label1.TabIndex = 0;
            this.label1.Text = "&Active Facility?";
            // 
            // cbActive
            // 
            this.cbActive.AccessibleDescription = "Active Facility";
            this.cbActive.AccessibleName = "Active Facility";
            this.cbActive.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbActive.Checked = true;
            this.cbActive.CheckState = System.Windows.Forms.CheckState.Checked;
            this.cbActive.Location = new System.Drawing.Point(256, 8);
            this.cbActive.Name = "cbActive";
            this.cbActive.Size = new System.Drawing.Size(24, 24);
            this.cbActive.TabIndex = 17;
            this.cbActive.CheckedChanged += new System.EventHandler(this.cbActive_CheckedChanged);
            // 
            // FrmCollectionFacilityMaintain
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(444, 505);
            this.Controls.Add(this.grpFacilityIndicator);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpAdditionalInfo);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.grpProduct);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.grpAddress);
            this.Controls.Add(this.grpActive);
            this.hlphelpChm.SetHelpKeyword(this, "Local_Facilities.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.MinimumSize = new System.Drawing.Size(452, 195);
            this.Name = "FrmCollectionFacilityMaintain";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "VBECS - Maintain Facility";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmCollectionFacilityMaintain_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.grpActive, 0);
            this.Controls.SetChildIndex(this.grpAddress, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpProduct, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpAdditionalInfo, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.grpFacilityIndicator, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpProduct.ResumeLayout(false);
            this.grpProduct.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox2)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpAddress.ResumeLayout(false);
            this.grpAddress.PerformLayout();
            this.grpAdditionalInfo.ResumeLayout(false);
            this.grpAdditionalInfo.PerformLayout();
            this.grpFacilityIndicator.ResumeLayout(false);
            this.grpActive.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion
		
		#region Properties

		/// <summary>
		/// FDA Registration Number of the "working with" facilty 
		/// </summary>
		public string FdaRegistrationNumber
		{
			get
			{
				return _fdaRegistrationNumber;
			}
			set
			{
				this.txtFDAReg.Text = value;
				_fdaRegistrationNumber = value;
			}
		}

		/// <summary>
		/// Current Local Supplier - ReadOnly
		/// </summary>
		public BOL.LocalSupplier LocalSupplier
		{
			get
			{
				return this._currentLocalSuplier;
			}
		}
		#endregion

		#region Methods
			
		/// <summary>
		/// Clears out all the error provider thingies that might be left...This should be made a "common" method
		/// </summary>
		private void ClearErrorProvider()
		{
			// **** 508 Compliance ***
			this.errError.SetVbecsError(this.btnSearch, string.Empty);
			this.errError.SetVbecsError(this.txtAddress1, string.Empty);
			this.errError.SetVbecsError(this.txtAddress2, string.Empty);
			this.errError.SetVbecsError(this.txtAddress3, string.Empty);
			this.errError.SetVbecsError(this.txtCity, string.Empty);
			this.errError.SetVbecsError(this.txtFacilityName, string.Empty);
			this.errError.SetVbecsError(this.mtxtZip, string.Empty);
			this.errError.SetVbecsError(this.mtxtFax, string.Empty);
			this.errError.SetVbecsError(this.mtxtPhone, string.Empty);
			this.errError.SetVbecsError(this.cmbState, string.Empty);
			this.errError.SetVbecsError(this.cbActive, string.Empty);
			this.errError.SetVbecsError(this.cbCollectionFacility, string.Empty);
			this.errError.SetVbecsError(this.cbTestingFacility, string.Empty);
			this.errError.SetVbecsError(this.txtIccbba, string.Empty);
		}

		/// <summary>
		/// Does the user have authority to be in this part of the application?
		/// </summary>
		/// <returns>True is Yes, False if No</returns>
		public bool HasAuthorityToAdd()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.AddNewLocalShipper );
		}

		/// <summary>
		/// Does the user have authority to be in this part of the application?
		/// </summary>
		/// <returns>True is Yes, False if No</returns>
		public bool HasAuthorityToActivateEdit()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.ActivateEditShipperInformation );
		}

		/// <summary>
		/// Sets the State property on the Address object
		/// </summary>
		private void SetState()
		{
			if (this._currentLocalSuplier == null) return;
			try
			{
				if (this.cmbState.SelectedIndex>-1)
				{
					this._currentLocalSuplier.Address.StateCode = cmbState.Text;
				}
				else
				{
					this._currentLocalSuplier.Address.StateCode = "";
				}
				this.errError.SetVbecsError(this.cmbState,string.Empty);
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.cmbState,err.Message);
			}
		}

		/// <summary>
		/// Attach events to the listeners so we can control broken rules, etc..
		/// </summary>
		private void AttachEvents()
		{
			if (this._currentLocalSuplier == null) return;
			this._currentLocalSuplier.Invalid += new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Valid += new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.IsDirtyChanged += new System.EventHandler(OnValidStateChanges);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//everytime a property of the bol variable is altered and thus the form
			//has been changed in one way or another.
			this._currentLocalSuplier.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);

			this._currentLocalSuplier.Address.Invalid += new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Address.Valid += new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Address.IsDirtyChanged += new System.EventHandler(OnValidStateChanges);
			//Setting the IsDirtyChanged event to fire the SetDirtyFlag function
			//everytime a property of the bol variable is altered and thus the form
			//has been changed in one way or another.
			this._currentLocalSuplier.Address.IsDirtyChanged += new System.EventHandler(SetDirtyFlag);
		}

		/// <summary>
		/// DeAttach events to the listeners as part of cleanup
		/// </summary>
		private void DeAttachEvents()
		{
			if (this._currentLocalSuplier == null) return;
			if (this.LocalSupplier == null) return;

			this._currentLocalSuplier.Invalid -= new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Valid -= new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.IsDirtyChanged -= new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.IsDirtyChanged -= new System.EventHandler(SetDirtyFlag);

			this._currentLocalSuplier.Address.Invalid -= new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Address.Valid -= new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Address.IsDirtyChanged -= new System.EventHandler(OnValidStateChanges);
			this._currentLocalSuplier.Address.IsDirtyChanged -= new System.EventHandler(SetDirtyFlag);
		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/10/2002</CreationDate>
		///Gets the message that states, do you have another local supplier to add or maintain
		private string GetAnotherMessageText()
		{
			string _anotherstring = string.Empty;

			try
			{
				_anotherstring = Common.StrRes.ConfMsg.UC006.AddorMaintainAnotherCollectionFacility().ResString;
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}

			return _anotherstring;
		}

		/// <summary>
		/// Sets the StateCode combobox to the index of the requesting statecode
		/// </summary>
		/// <param name="stateCode"></param>
		private void SetCmbStateText(string stateCode)
		{
			cmbState.SelectedIndex = -1;

			for (int ndx=0; ndx < this.cmbState.Items.Count; ndx++)
			{
				if (cmbState.Items[ndx].ToString() == stateCode)
				{
					cmbState.SelectedIndex = ndx;
					break;
				}
			}
		}

		/// <summary>
		/// Creates and loads the _currentLocalSuplier object
		/// </summary>
		/// <param name="fdaRegistrationNumber">Which facility</param>
		private bool SetCurrentCollectionFacility(string fdaRegistrationNumber)
		{
			try
			{
				this._isBrandNewFacility = false;

				this.UnlockAllRecords();
				this.ClearErrorProvider();
				
				if(this._currentLocalSuplier == null)
				{
					this._currentLocalSuplier = new BOL.LocalSupplier(fdaRegistrationNumber,false);
					if(this.txtIccbba.Text.Trim().Length == 5)
					{
						this._currentLocalSuplier.IccbbaRegistrationNumber = this.txtIccbba.Text;
					}
				}
				else
				{
					string iccbba = this._currentLocalSuplier.IccbbaRegistrationNumber;
					if(iccbba.Trim().Length > 0)
					{
						this._currentLocalSuplier = new BOL.LocalSupplier(fdaRegistrationNumber,false);
						this._currentLocalSuplier.IccbbaRegistrationNumber = iccbba;
					}
				}
				if(this._currentLocalSuplier.IccbbaRegistrationNumber.Trim().Length > 0)
				{
					this.txtIccbba.ReadOnly = true; //508 compliance
				}
				else
				{
					this.txtIccbba.ReadOnly = false; //508 compliance
				}

				//If the collectionFacilty doesn't exist, it'll be new, and we'll want to set broken rules
				if (this._currentLocalSuplier.IsNew)
				{
					this._isBrandNewFacility = true;

					//If the RecordStatusCode <> N, then it's a NON Vbecs National Table facility
					//Only level 5 users can add "new" facilities to the database
					if (this._currentLocalSuplier.RecordStatusCode != Common.RecordStatusCode.NationalStandard && !this.HasAuthorityToAdd())
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC001.NoAuthorityToAddFacility());
						return(false);
					}

					//Still must lock the Address record for new entries -- Addresses can be shared/edited accross division
                    this.LockController.RecordGuids.Add(this._currentLocalSuplier.Address.AddressGuid);
					if (!this.SetLocks())
					{
						this._currentLocalSuplier = null;
						return(false);
					}

					this._currentLocalSuplier.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.NewLocalSupplier);
					this._currentLocalSuplier.Address.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.NewAddress);
					this._currentLocalSuplier.FDARegistrationNumber = fdaRegistrationNumber.Trim();
					
					//BR_6.05 - CollectionFacility is default
					this._currentLocalSuplier.IsCollectionFacility = true;

					//Becuase of the National table, we need to do some "cheating"..until I figure out the "right" way
					//Setting all these dumb properties is to "turn on/off" broken rules
					if (this._currentLocalSuplier.RecordStatusCode == Common.RecordStatusCode.NationalStandard)
					{
						//We're pulling the name from the national table...
						this._currentLocalSuplier.FacilityName = this._currentLocalSuplier.FacilityName;
						this._currentLocalSuplier.Address.AddressLine1 = this._currentLocalSuplier.Address.AddressLine1;
						this._currentLocalSuplier.Address.City = this._currentLocalSuplier.Address.City;
						this._currentLocalSuplier.Address.StateCode = this._currentLocalSuplier.Address.StateCode;
						this._currentLocalSuplier.Address.ZipCode = this._currentLocalSuplier.Address.ZipCode;
						this._currentLocalSuplier.RecordStatusCode = Common.RecordStatusCode.Inactive;
					}
					else
					{
						this._currentLocalSuplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
					}
				}
				else
				{
                    this.LockController.RecordGuids.Add(this._currentLocalSuplier.LocalSupplierGuid);
                    this.LockController.RecordGuids.Add(this._currentLocalSuplier.Address.AddressGuid);
					if (!this.SetLocks()) return(false);

					this._currentLocalSuplier.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.ExistingLocalSupplier);
					this._currentLocalSuplier.Address.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.ExistingAddress);
					//Force them to continue working with what they've got.  We don't force with New because if they've
					//only typed 7char FDA#, they might want 10.  We force there on txtFDAReg_Leave()
				}

				SetControlData(false);
				SetControlState(true);
				AttachEvents();

				OnValidStateChanges(null, EventArgs.Empty );
				return true;
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.btnSearch, err.Message);
				return false;
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
				this.errError.SetVbecsError(this.btnSearch, err.Message);
				return false;
			}
		}
		/// <summary>
		/// SetCurrentCollectionFacility
		/// </summary>
		/// <param name="iccbaRegNumber"></param>
		/// <param name="test"></param>
		/// <returns></returns>
		private bool SetCurrentCollectionFacility(string iccbaRegNumber, bool test)
		{
			try
			{
				this._isBrandNewFacility = false;

				this.UnlockAllRecords();
				this.ClearErrorProvider();

				this._currentLocalSuplier = new BOL.LocalSupplier(false, iccbaRegNumber);

				//If the collectionFacilty doesn't exist, it'll be new, and we'll want to set broken rules
				if (this._currentLocalSuplier.IsNew)
				{
					this._isBrandNewFacility = true;

					//If the RecordStatusCode <> N, then it's a NON Vbecs National Table facility
					//Only level 5 users can add "new" facilities to the database
					if (this._currentLocalSuplier.RecordStatusCode != Common.RecordStatusCode.NationalStandard && !this.HasAuthorityToAdd())
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.UC001.NoAuthorityToAddFacility());
						return(false);
					}

					//Still must lock the Address record for new entries -- Addresses can be shared/edited accross division
                    this.LockController.RecordGuids.Add(this._currentLocalSuplier.Address.AddressGuid);
					if (!this.SetLocks()) 
					{
						this.DeAttachEvents();
						this._currentLocalSuplier = null;
						return(false);
					}

					this._currentLocalSuplier.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.NewLocalSupplier);
					this._currentLocalSuplier.Address.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.NewAddress);
					this._currentLocalSuplier.IccbbaRegistrationNumber = iccbaRegNumber.Trim();
					
					//BR_6.05 - CollectionFacility is default
					this._currentLocalSuplier.IsCollectionFacility = true;

					//Becuase of the National table, we need to do some "cheating"..until I figure out the "right" way
					//Setting all these dumb properties is to "turn on/off" broken rules
					if (this._currentLocalSuplier.RecordStatusCode == Common.RecordStatusCode.NationalStandard)
					{
						//We're pulling the name from the national table...
						this._currentLocalSuplier.FacilityName = this._currentLocalSuplier.FacilityName;
						this._currentLocalSuplier.FDARegistrationNumber = this._currentLocalSuplier.FDARegistrationNumber;
						this._currentLocalSuplier.Address.AddressLine1 = this._currentLocalSuplier.Address.AddressLine1;
						this._currentLocalSuplier.Address.City = this._currentLocalSuplier.Address.City;
						this._currentLocalSuplier.Address.StateCode = this._currentLocalSuplier.Address.StateCode;
						this._currentLocalSuplier.Address.ZipCode = this._currentLocalSuplier.Address.ZipCode;
						this._currentLocalSuplier.RecordStatusCode = Common.RecordStatusCode.Inactive;
					}
					else
					{
						this._isBrandNewFacility = true;
						this._currentLocalSuplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
					}
				}
				else
				{
                    this.LockController.RecordGuids.Add(this._currentLocalSuplier.LocalSupplierGuid);
                    this.LockController.RecordGuids.Add(this._currentLocalSuplier.Address.AddressGuid);
					if (!this.SetLocks()) return(false);

					this._currentLocalSuplier.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.ExistingLocalSupplier);
					this._currentLocalSuplier.Address.SetInitialBrokenRules(this.Name, Common.VbecsBrokenRules.FrmCollectionFacilityMaintain.RuleSets.ExistingAddress);
					//Force them to continue working with what they've got.  We don't force with New because if they've
					//only typed 7char FDA#, they might want 10.  We force there on txtFDAReg_Leave()
				}

				SetControlData(false);
				SetControlState(true);
				AttachEvents();

				OnValidStateChanges(null, EventArgs.Empty );
				return true;
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtIccbba, err.Message);
				this.DeAttachEvents();
				this._currentLocalSuplier = null;
				return false;
			}
			catch(Exception err)
			{
				this.DeAttachEvents();
				this._currentLocalSuplier = null;
				this.errError.SetVbecsError(this.txtIccbba, Common.StrRes.SysErrMsg.Common.UnexpectedException(err).ToString());
				return false;
			}
		}
		/// <summary>
		/// Populates the form controls
		/// </summary>
		/// <param name="isNew">If our object is new, we load with blanks/defaults</param>
		private void SetControlData(bool isNew)
		{
			this._isLoading = true;

			if (isNew)
			{
				this.UnlockAllRecords();

				this.txtFacilityName.Text = string.Empty;
				if(this._currentLocalSuplier != null)
				{
					if(this._currentLocalSuplier.IccbbaRegistrationNumber == string.Empty)
					{
						this.txtIccbba.Text = string.Empty;
					}
				}
					//If we are coming from UC_01 we do not want to erase the iccba number
				else if(!this._processOne)
				{
					this.txtIccbba.Text = string.Empty;
				}
				this.txtAddress1.Text = string.Empty;
				this.txtAddress2.Text = string.Empty;
				this.txtAddress3.Text = string.Empty;

				this.txtCity.Text = string.Empty;
				this.cmbState.SelectedIndex = -1;
				this.mtxtZip.SetText(string.Empty);

				this.mtxtPhone.SetText(string.Empty);
				this.mtxtFax.SetText(string.Empty);

				this.cbAlpha.Checked = false;
				this.edtPrefix.Text = string.Empty;

				this.cbCollectionFacility.Checked = true;
				this.cbTestingFacility.Checked = false;
				this.cbActive.Checked = true;
			}
			else
			{
				this.txtFDAReg.Text = this._currentLocalSuplier.FDARegistrationNumber.Trim();
				this.txtFacilityName.Text = this._currentLocalSuplier.FacilityName;
				this.txtIccbba.Text = this._currentLocalSuplier.IccbbaRegistrationNumber;
				
				this.txtAddress1.Text = this._currentLocalSuplier.Address.AddressLine1;
				this.txtAddress2.Text = this._currentLocalSuplier.Address.AddressLine2;
				this.txtAddress3.Text = this._currentLocalSuplier.Address.AddressLine3;
				this.txtCity.Text = this._currentLocalSuplier.Address.City;

				this.SetCmbStateText(this._currentLocalSuplier.Address.StateCode);

				this.mtxtZip.SetText(this._currentLocalSuplier.Address.ZipCode.Trim());
				this.mtxtPhone.SetText(this._currentLocalSuplier.PhoneNumber.Trim());
				this.mtxtFax.SetText(this._currentLocalSuplier.FaxNumber.Trim());

				this.cbAlpha.Checked = this._currentLocalSuplier.LabelUnitIDTrimIndicator;
				this.edtPrefix.Text = this._currentLocalSuplier.FacilityPrefix;	

				this.cbCollectionFacility.Checked = this._currentLocalSuplier.IsCollectionFacility;
				this.cbTestingFacility.Checked = this._currentLocalSuplier.IsTestingFacility;
				this.cbActive.Checked = (this._currentLocalSuplier.RecordStatusCode != Common.RecordStatusCode.Inactive);
			}

			this._isLoading = false;
		}

		/// <summary>
		/// Enables or disables the form controls
		/// </summary>
		/// <param name="enableControls">True to disable/ReadOnly controls</param>
		private void SetControlState(bool enableControls)
		{
			this.grpAddress.Enabled = enableControls;
			this.grpAdditionalInfo.Enabled = enableControls;
			this.grpFacilityIndicator.Enabled = enableControls;
			this.grpActive.Enabled = enableControls;

			this.grpAddress.Visible = enableControls;
			this.grpAdditionalInfo.Visible = enableControls;
			this.grpFacilityIndicator.Visible = enableControls;
			this.grpActive.Visible = enableControls;
			
			if(enableControls)
			{
				this.Height = 539;
			}
			else
			{
				this.Height = 195;
			}
			//FacilityName && ICCBBA are separate because FDA Reg NUm is sometimes disabled
			//Or enabled on first entry
			this.txtFacilityName.ReadOnly = !enableControls;
			if(this._ISBT)
			{
				this.txtIccbba.ReadOnly = true;
			}
			else
			{
				if(this._currentLocalSuplier != null)
				{
					//If there is an existing record and they iccba number is blank it should be 
					//enabled for entry
					if(this._currentLocalSuplier.IccbbaRegistrationNumber.Trim().Length == 0)
					{
						this.txtIccbba.ReadOnly = !enableControls;
					}
				}
				else
				{
					this.txtIccbba.ReadOnly = (!this._isBrandNewFacility && !enableControls);
				}
			}
			this.edtPrefix.ReadOnly = !enableControls;	

			//We don't want to allow the user to enter a new supplier, only existing ones
			if(this._currentLocalSuplier != null)
			{
				if (this._processOne && this._currentLocalSuplier.FDARegistrationNumber.Trim().Length > 0)
				{
					this.txtFDAReg.ReadOnly = true;
				}
				else
				{
					this.txtFDAReg.ReadOnly = false;
				}
			}
			else
			{
				if (this._processOne && this.txtFDAReg.Text.Trim().Length > 6)
				{
					this.txtFDAReg.ReadOnly = true;
				}
				else
				{
					this.txtFDAReg.ReadOnly = false;
				}
			}
		}

		/// <summary>
		/// Loads the defaults -- Form Initialize
		/// </summary>
		private void SetComponentProperties()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC006MaintainCollectionFacility;
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC006.FrmCollectionFacilityMaintain());

			vbecsLogo1.Title = "Maintain Facility";
			cmbState.Items.AddRange(BOL.ReferenceData.GetStateCodes());

			this.errError.SetIconAlignment(this.mtxtFax, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);
			this.errError.SetIconAlignment(this.mtxtPhone, System.Windows.Forms.ErrorIconAlignment.MiddleLeft);

			this.mtxtPhone.MaskedTextInvalidated += new EventHandler(this.PhoneTextBoxInvalid);
			this.mtxtPhone.MaskedTextValidated += new EventHandler(this.PhoneTextBoxValid);
			this.mtxtFax.MaskedTextInvalidated += new EventHandler(this.FaxTextBoxInvalid);
			this.mtxtFax.MaskedTextValidated += new EventHandler(this.FaxTextBoxValid);

			//Set the tooltips for the controls
			this.toolTip1.SetToolTip(this.btnCancel , Common.StrRes.Tooltips.Common.Cancel().ResString);
			this.toolTip1.SetToolTip(this.btnClear , Common.StrRes.Tooltips.UC006.btnClear().ResString);
			this.toolTip1.SetToolTip(this.btnSearch , Common.StrRes.Tooltips.UC006.btnSearch().ResString);
			this.toolTip1.SetToolTip(this.cbActive , Common.StrRes.Tooltips.UC006.cbActive().ResString);
			this.toolTip1.SetToolTip(this.cbAlpha , Common.StrRes.Tooltips.UC006.cbAlpha().ResString);
			this.toolTip1.SetToolTip(this.cbCollectionFacility , Common.StrRes.Tooltips.UC006.cbCollectionFacility().ResString);
			this.toolTip1.SetToolTip(this.cbTestingFacility , Common.StrRes.Tooltips.UC006.cbTestingFacility().ResString);
			this.toolTip1.SetToolTip(this.cmbState , Common.StrRes.Tooltips.UC006.cmbState().ResString);
			this.toolTip1.SetToolTip(this.edtPrefix , Common.StrRes.Tooltips.UC006.edtPrefix().ResString);
			this.toolTip1.SetToolTip(this.mtxtFax , Common.StrRes.Tooltips.UC006.mtxtFax().ResString);
			this.toolTip1.SetToolTip(this.mtxtPhone , Common.StrRes.Tooltips.UC006.mtxtPhone().ResString);
			this.toolTip1.SetToolTip(this.txtAddress1 , Common.StrRes.Tooltips.UC006.txtAddress1().ResString);
			this.toolTip1.SetToolTip(this.txtAddress2 , Common.StrRes.Tooltips.UC006.txtAddress2().ResString);
			this.toolTip1.SetToolTip(this.txtAddress3 , Common.StrRes.Tooltips.UC006.txtAddress3().ResString);
			this.toolTip1.SetToolTip(this.txtCity , Common.StrRes.Tooltips.UC006.txtCity().ResString);
			this.toolTip1.SetToolTip(this.txtFacilityName , Common.StrRes.Tooltips.UC006.txtFacilityName().ResString);
			this.toolTip1.SetToolTip(this.txtFDAReg , Common.StrRes.Tooltips.UC006.txtFDAReg().ResString);
			this.toolTip1.SetToolTip(this.mtxtZip , Common.StrRes.Tooltips.UC006.mtxtZip().ResString);
			this.toolTip1.SetToolTip(this.txtIccbba, Common.StrRes.Tooltips.UC006.IccbbaRegistrationNumber().ResString);
		}

		#endregion

		#region Events
		/// <summary>
		/// Sets the state of the 'OK' button depending on whether business 
		/// objects are valid or invalid. Also sets / clears validation message tooltip.
		/// </summary>
		private void OnValidStateChanges( object sender, EventArgs e )
		{
		    if (this._currentLocalSuplier == null) return;
			if(this._currentLocalSuplier.Address == null) return;
			btnOK.EnabledButton =	_currentLocalSuplier.IsValid && 
									_currentLocalSuplier.Address.IsValid &&
									(_currentLocalSuplier.IsDirty ||
									 _currentLocalSuplier.Address.IsDirty) &&
									(this.errError.GetError(this.txtIccbba) == string.Empty);
									
			
			string tooltip = Common.Utility.SumBrokenRulesMessages( 
								_currentLocalSuplier.GetBrokenRulesMessage( this.Name ),
								_currentLocalSuplier.Address.GetBrokenRulesMessage( this.Name ),
								this.errError.GetError(this.txtIccbba));

			if (tooltip.Length == 0)
			{
				if (btnOK.EnabledButton == false)
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
				}
				else
				{
					this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
				}
			}
			else
			{
				this.btnOK.SetToolTip(tooltip);
			}


		}

		#endregion

		#region ControlEvents

		/// <summary>
		/// cbAlpha_CheckedChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbAlpha_CheckedChanged(object sender, System.EventArgs e)
		{
			if (this._currentLocalSuplier == null) return;
			if (!this._isLoading)
			{
				try
				{
					this._currentLocalSuplier.LabelUnitIDTrimIndicator = cbAlpha.Checked;
					this.errError.SetVbecsError(this.cbAlpha, string.Empty);
				}
				catch(BOL.BusinessObjectException err)
				{
					this.errError.SetVbecsError(this.cbAlpha, err.Message);
				}
				catch(Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
				}
			}											  
		}

		/// <summary>
		/// edtPrefix_TextChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void edtPrefix_TextChanged(object sender, System.EventArgs e)
		{
			if (this._currentLocalSuplier == null) return;
			if (!this._isLoading)
			{
				try
				{
					this._currentLocalSuplier.FacilityPrefix = edtPrefix.Text;
					this.errError.SetVbecsError(edtPrefix,string.Empty);
				}
				catch(BOL.BusinessObjectException err)
				{
					this.errError.SetVbecsError(this.edtPrefix, err.Message);
				}
				catch(Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
				}
			}
		}

		/// <summary>
		/// btnOK_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			bool bSaved = false;
			DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("local supplier"));
			
			if( _saveResult != DialogResult.Yes ) return;

			try
			{
				if(this._currentLocalSuplier.IsNew)
				{
					bSaved = this._currentLocalSuplier.InsertLocalSupplier(Common.UpdateFunction.UC006FrmCollectionFacilityMaintain);
				}
				else
				{
					bSaved = this._currentLocalSuplier.UpdateLocalSupplier(Common.UpdateFunction.UC006FrmCollectionFacilityMaintain);
				}
				
				if( bSaved ) 
				{
					this.IsDirty=false;

					if (this._processOne)
					{
						this.DialogResult = DialogResult.OK;
						this.Close();
					}
					else
					{
						this._isBrandNewFacility = false;
						this.SetControlData(true);
						this.SetControlState(false);
						this.txtFDAReg.Text = string.Empty;
						this.txtIccbba.Text = string.Empty;
						this.txtFDAReg.ReadOnly = false;
						this.btnSearch.Enabled = true;
						this.txtFDAReg.Focus();
						this.btnOK.EnabledButton = false;
						this.DialogResult = DialogResult.None;
						this.DeAttachEvents();
						this._currentLocalSuplier = null;
					}
				}
				else
				{
					//If data wasn't saved -- it should be this message, so show'm
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Local supplier" ));
				}
				
			}
			catch(Common.RowVersionException)
			{
				this.btnOK.RowVersionException = true;		//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
			}
			catch(Exception)
			{
				//This is in here for when 2 users try to either 
				//		A) add the same new supplier
				//		B) add the same facility AS a local supplier for the first time
				// at the same time
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("Local supplier" ));
			}
		}

		/// <summary>
		/// txtFacilityName_KeyUp
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtFacilityName_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			try
			{
				if(this._currentLocalSuplier != null)
				{
					this._currentLocalSuplier.FacilityName = this.txtFacilityName.Text;
					this.errError.SetVbecsError(this.txtFacilityName,string.Empty);
				}
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtFacilityName, err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		/// <summary>
		/// txtAddress1_KeyUp
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtAddress1_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (this._currentLocalSuplier == null) return;
			try
			{
				this._currentLocalSuplier.Address.AddressLine1 = txtAddress1.Text;
				this.errError.SetVbecsError(this.txtAddress1,string.Empty);
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtAddress1, err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}

		}

		/// <summary>
		/// txtAddress2_KeyUp
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtAddress2_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if( _currentLocalSuplier == null ) return;

			try
			{
				this._currentLocalSuplier.Address.AddressLine2 = txtAddress2.Text;
				this.errError.SetVbecsError(this.txtAddress2,string.Empty);
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtAddress2, err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		/// <summary>
		/// txtAddress3_KeyUp
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtAddress3_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if( _currentLocalSuplier == null ) return;

			try
			{								
				this._currentLocalSuplier.Address.AddressLine3 = txtAddress3.Text;
				this.errError.SetVbecsError(this.txtAddress3,string.Empty);
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtAddress3,err.Message);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		/// <summary>
		/// txtCity_KeyUp
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtCity_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (this._currentLocalSuplier == null) return;
			try
			{
				this._currentLocalSuplier.Address.City = txtCity.Text;
				this.errError.SetVbecsError(this.txtCity,string.Empty);
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtCity , err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}

		}

		/// <summary>
		/// cmbState_SelectedIndexChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cmbState_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (!this._isLoading) SetState();
		}

		/// <summary>
		/// mtxtPhone_Leave
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void mtxtPhone_Leave(object sender, System.EventArgs e)
		{
			if (this._currentLocalSuplier == null) return;
			try
			{
				this._currentLocalSuplier.PhoneNumber = mtxtPhone.GetText();
				this.errError.SetVbecsError(this.mtxtPhone,string.Empty);
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.mtxtPhone,err.Message);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		/// <summary>
		/// mtxtFax_Leave
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void mtxtFax_Leave(object sender, System.EventArgs e)
		{
			if (this._currentLocalSuplier == null) return;
			try
			{
				this._currentLocalSuplier.FaxNumber = mtxtFax.GetText();
				this.errError.SetVbecsError(this.mtxtFax,string.Empty);
			}
			catch (BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.mtxtFax,err.Message);
			}
			catch (Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		/// <summary>
		/// btnCancel_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// btnSearch_Click
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSearch_Click(object sender, System.EventArgs e)
		{
			DlgFacilitySearch dlg = new DlgFacilitySearch(this.txtFDAReg.Text);

            dlg.ShowDialogFromLockedParent(this, false);

			if (dlg.DialogResult == System.Windows.Forms.DialogResult.OK)
			{
				this.DeAttachEvents();
				this._currentLocalSuplier = null;
				if (this.SetCurrentCollectionFacility(dlg.FdaRegistrationNumber))
				{
					this.txtFDAReg.ReadOnly = true;
				}
			}

			dlg.Dispose();
		}


		/// <summary>
		/// txtFDAReg_TextChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtFDAReg_TextChanged(object sender, System.EventArgs e)
		{
			if( this._isLoading ) return;


			if (!this.txtFDAReg.Barcode)
			{
				if ((this.txtFDAReg.Text.Trim().Length == 7) || (this.txtFDAReg.Text.Trim().Length == 10))
				{
					this.SetCurrentCollectionFacility(this.txtFDAReg.Text.Trim());
				}
				else
				{
					this.DeAttachEvents();
					this._currentLocalSuplier = null;
					this.btnOK.SetToolTip(string.Empty);
					this.SetControlData(true);
					this.SetControlState(false);
				}
			}
		}

		/// <summary>
		/// cbCollectionFacility_CheckedChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbCollectionFacility_CheckedChanged(object sender, System.EventArgs e)
		{
			if( this._isLoading ) return;
		    if (this._currentLocalSuplier == null) return;
			this._currentLocalSuplier.IsCollectionFacility = cbCollectionFacility.Checked;
			this.errError.SetVbecsError(this.cbCollectionFacility,string.Empty);
			this.errError.SetVbecsError(this.cbTestingFacility,string.Empty);
		}

		/// <summary>
		/// cbTestingFacility_CheckedChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbTestingFacility_CheckedChanged(object sender, System.EventArgs e)
		{
			if( this._isLoading ) return;
			if (this._currentLocalSuplier == null) return;
			

			this._currentLocalSuplier.IsTestingFacility = cbTestingFacility.Checked;
			this.errError.SetVbecsError(this.cbCollectionFacility,string.Empty);
			this.errError.SetVbecsError(this.cbTestingFacility,string.Empty);
		}

		/// <summary>
		/// txtFDAReg_Leave
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtFDAReg_Leave(object sender, System.EventArgs e)
		{
			//BR_1.11
				if (this.txtFDAReg.Barcode)
			{
				if (this.txtFDAReg.Text.Trim().Length == 9)
				{
					this.txtFDAReg.Text = this.txtFDAReg.Text.Substring(1,7);
				}
				if (this.txtFDAReg.Text.Trim().Length == 12)
				{
					this.txtFDAReg.Text = this.txtFDAReg.Text.Substring(1,10);
				}

				if (this.txtFDAReg.Text.Trim().Length == 7 || this.txtFDAReg.Text.Trim().Length == 10)
					if (!this.SetCurrentCollectionFacility(this.txtFDAReg.Text.Trim()))
						return;
			}
		
		
			//We want this code to happen regardless of scan or not
			if ((this.txtFDAReg.Text.Trim().Length == 7) || (this.txtFDAReg.Text.Trim().Length == 10)) 
			{
				this.txtFDAReg.ReadOnly = !(this.errError.GetError(this.btnSearch).Length > 0);
			}
		}

		/// <summary>
		/// When they click the clear  button.. reset everything
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			this._isBrandNewFacility = false;

			//Unlocking in SetControlData to reuse code
			this.SetControlData(true);
			this.SetControlState(false);
			this.txtFDAReg.Text = string.Empty;
			this.txtIccbba.Text = string.Empty;
			this.txtFDAReg.Focus();
			this.btnOK.EnabledButton = false;
			this.ClearErrorProvider();
			this.IsDirty = false;
			this.DeAttachEvents();
			this._currentLocalSuplier = null;
		}


		/// <summary>
		/// cbActive_CheckedChanged
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void cbActive_CheckedChanged(object sender, System.EventArgs e)
		{
			if( this._isLoading ) return;
			if(this._currentLocalSuplier ==null) return;
			try
			{
				if (this.cbActive.Checked == false)
				{
					
					if (BOL.LocalSupplier.IsLocalSupplierOnActiveBloodProducts(this._currentLocalSuplier.LocalSupplierGuid) == true || BOL.LocalSupplier.IsLocalSupplierOnActiveBloodUnits(this._currentLocalSuplier.FDARegistrationNumber) == true)
					{
						//Displaying BR_8.11 message
						GuiMessenger.ShowMessageBox(Common.StrRes.ValidMsg.Common.BR811InactivateSupplier()); 
						this.cbActive.Checked = true;
						return;
					}
						//Displaying BR_6.06 message
					else if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC006.InactivateFacility()) != DialogResult.Yes)
					{
						this.cbActive.Checked = true;
						return;
					}
					else
					{
						//Set the Record Status Code to Inactive - 'X'
						this._currentLocalSuplier.RecordStatusCode = Common.RecordStatusCode.Inactive;
					}
				}
				else
				{
					this._currentLocalSuplier.RecordStatusCode = Common.RecordStatusCode.LocalEntry;
				}

				this.errError.SetVbecsError(this.cbActive,string.Empty);

			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.cbActive, err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}

		}

		private void PhoneTextBoxValid(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.mtxtPhone, string.Empty);
		}

		private void PhoneTextBoxInvalid(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.mtxtPhone, (string) sender);
		}

		private void FaxTextBoxValid(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.mtxtFax, string.Empty);
		}

		private void FaxTextBoxInvalid(object sender, System.EventArgs e)
		{
			this.errError.SetVbecsError(this.mtxtFax, (string) sender);
		}

		private void txtIccbba_KeyUp(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			try
			{
				if(this._currentLocalSuplier != null)
				{
					this._currentLocalSuplier.IccbbaRegistrationNumber = this.txtIccbba.Text;
					this.errError.SetVbecsError(this.txtIccbba,string.Empty);
				}
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.txtIccbba, err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
			finally
			{
				this.OnValidStateChanges(this, System.EventArgs.Empty);
			}
		}

		private void mtxtZip_MaskedTextInvalidated(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				if(this._currentLocalSuplier != null)
				{
					this._currentLocalSuplier.Address.ZipCode = string.Empty;
					this.errError.SetVbecsError(this.mtxtZip, string.Empty );
				}
			}
		}

		private void mtxtZip_MaskedTextValidated(object sender, System.EventArgs e)
		{
			try
			{
				if(!this._isLoading)
				{
					if(this._currentLocalSuplier != null)
					{
						this._currentLocalSuplier.Address.ZipCode = this.mtxtZip.GetText();
						this.errError.SetVbecsError(this.mtxtZip, string.Empty );
					}
				}
			}
			catch(BOL.BusinessObjectException err)
			{
				this.errError.SetVbecsError(this.mtxtZip, err.Message);
			}
			catch(Exception err)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.UnexpectedException(err));
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmCollectionFacilityMaintain_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if ( !this.btnOK.EnabledButton )
			{
				textToSpeak = this.btnOK.GetToolTip();
			}
			//
			this.SpeakMessage( textToSpeak );
		}

		#endregion
	}
}
